/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.ironchests.api.property;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import tech.thatgravyboat.ironchests.api.property.base.IBlockProperty;
import tech.thatgravyboat.ironchests.api.property.base.IBlockPropertyType;
import tech.thatgravyboat.ironchests.api.property.properties.BuilderProperty;
import tech.thatgravyboat.ironchests.api.property.properties.ReferenceProperty;

public class Properties {
    public static final Codec<IBlockPropertyType> TYPE_CODEC = Codec.STRING.comapFlatMap(Properties::decode, IBlockPropertyType::getId);
    public static final Codec<IBlockProperty> CODEC = TYPE_CODEC.dispatch(IBlockProperty::getType, IBlockPropertyType::codec);
    private static final Map<String, IBlockPropertyType> PROPERTY_MAP = new HashMap<String, IBlockPropertyType>();

    private static DataResult<IBlockPropertyType> decode(String id) {
        return Optional.ofNullable(PROPERTY_MAP.get(id)).map(DataResult::success).orElse(DataResult.error((String)"No property type found."));
    }

    static {
        PROPERTY_MAP.put("reference", ReferenceProperty.TYPE);
        PROPERTY_MAP.put("builder", BuilderProperty.TYPE);
    }
}

